	/**********************************************************************************************
	* Replication code for "Bubbles and crises: The role of house prices and credit", Journal of Applied Econometrics
	*
	*
	* This code creates Figures 1-3 and 5-6 and Table 1-2 in the Paper. Figure 4 and all appendix material
	* is created by running the code "main_appendix.do"
	***********************************************************************************************/ 
	
	
	** Define working directory 
	clear all
	set more off
	
	***********************************************************************************
	*** global 		main    "YOUR LOCAL PATH" ***
	***********************************************************************************

	global dataPath 	  "$main/Data"
	global outputTables   "$main/Tables"
	global outputFigures  "$main/Figures"
	global codePath       "$main/Do files"
	global outputPath     "$main/Output"

	
	***********************************************************************************************
	*      Figure 1 and Figure 2            								     **
	***********************************************************************************************

	do "$codePath/Figure 1 and 2.do"  


	***********************************************************************************************
	*      Figure  5       								     **
	***********************************************************************************************
	
	do "$codePath/Figure 5.do"  
	 

	***********************************************************************************************
	**     Table 2           								     **
	***********************************************************************************************
    
	do "$codePath/Table 2.do"

	***********************************************************************************************
	**     Table 3           								     **
	***********************************************************************************************
    
	do "$codePath/Table 3.do"

	***********************************************************************************************
	*      Figure  6       								     **
	***********************************************************************************************
	
	do "$codePath/Figure 6.do"  
	

	
